USE standardupdate_csv_21;

SET FOREIGN_KEY_CHECKS = 0;
TRUNCATE ITscope_Product;
TRUNCATE ITscope_SupplierItem;
TRUNCATE ITscope_Project;
TRUNCATE ITscope_SupplierPackagingInfo;
TRUNCATE ITscope_ScaledPriceInfo;
SET FOREIGN_KEY_CHECKS = 1;

LOAD DATA INFILE 'C:/temp/standardupdate_csv_21/product.csv'
  INTO TABLE ITscope_Product
  CHARACTER SET 'utf8'
  FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
  IGNORE 1 LINES
  (@puid, @price, @priceCalc, @currencyCode, @priceCalcVat, @priceLastUpdate, @priceSupplierId, @priceSupplierName, @priceSupplierItemId, @priceSupplierSKU,
   @stockSupplierText, @stockStatus, @stockStatusText, @stock, @externalStock, @incomingStock, @stockAvailabilityDate, @stockLastUpdate, @aggregatedStatus,
   @aggregatedStatusText, @aggregatedStock, @aggregatedSupplierItems,@contractTypeName,@priceBillingPeriod,@priceBillingPeriodUnit,@priceSubscriptionPeriod,@priceSubscriptionPeriodUnit,@priceCalcNet)
  SET
    puid = nullif(@puid, ''),
    price = nullif(@price, ''),
    priceCalc = nullif(@priceCalc, ''),
    currencyCode = nullif(@currencyCode, ''),
    priceCalcVat = nullif(@priceCalcVat, ''),
    priceLastUpdate = if(@priceLastUpdate = '',null,STR_TO_DATE(@priceLastUpdate, '%d.%m.%Y %H:%i')),
    priceSupplierId = nullif(@priceSupplierId, ''),
    priceSupplierName = nullif(@priceSupplierName, ''),
    priceSupplierItemId = nullif(@priceSupplierItemId, ''),
    priceSupplierSKU = nullif(@priceSupplierSKU, ''),
    stockSupplierText = nullif(@stockSupplierText, ''),
    stockStatus = nullif(@stockStatus, ''),
    stockStatusText = nullif(@stockStatusText, ''),
    stock = nullif(@stock, ''),
    externalStock = nullif(@externalStock, ''),
    incomingStock = nullif(@incomingStock, ''),
    stockAvailabilityDate = if(@stockAvailabilityDate = '',null,STR_TO_DATE(@stockAvailabilityDate, '%d.%m.%Y %H:%i')),
    stockLastUpdate = if(@stockLastUpdate = '',null,STR_TO_DATE(@stockLastUpdate, '%d.%m.%Y %H:%i')),
    aggregatedStatus = nullif(@aggregatedStatus, ''),
    aggregatedStatusText = nullif(@aggregatedStatusText, ''),
    aggregatedStock = nullif(@aggregatedStock, ''),
    aggregatedSupplierItems = nullif(@aggregatedSupplierItems, ''),
    priceBillingPeriod = nullif(@priceBillingPeriod, ''),
    priceBillingPeriodUnit = nullif(@priceBillingPeriodUnit, ''),
    priceSubscriptionPeriod = nullif(@priceSubscriptionPeriod, ''),
    priceSubscriptionPeriodUnit = nullif(@priceSubscriptionPeriodUnit, ''),
    priceCalcNet = nullif(@priceCalcNet, '');

LOAD DATA INFILE 'C:/temp/standardupdate_csv_21/supplierItem.csv'
  INTO TABLE ITscope_SupplierItem
  CHARACTER SET 'utf8'
  FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
  IGNORE 1 LINES
  (@id, @productId, @supplierSKU, @supplierId, @supplierName, @price, @priceCalc, @currencyCode, @priceCalcVat, @priceLastUpdate, @stockSupplierText,
   @stockStatus, @stockStatusText, @stock, @externalStock, @incomingStock, @stockAvailabilityDate, @lastStockUpdate,@priceBillingPeriod,@priceBillingPeriodUnit,@priceSubscriptionPeriod,@priceSubscriptionPeriodUnit,@priceCalcNet)
  SET
    id = nullif(@id, ''),
    productId = nullif(@productId, ''),
    supplierSKU = nullif(@supplierSKU, ''),
    supplierId = nullif(@supplierId, ''),
    supplierName = nullif(@supplierName, ''),
    price = nullif(@price, ''),
    priceCalc = nullif(@priceCalc, ''),
    currencyCode = nullif(@currencyCode, ''),
    priceCalcVat = nullif(@priceCalcVat, ''),
    priceLastUpdate = if(@priceLastUpdate = '',null,STR_TO_DATE(@priceLastUpdate, '%d.%m.%Y %H:%i')),
    stockSupplierText = nullif(@stockSupplierText, ''),
    stockStatus = nullif(@stockStatus, ''),
    stockStatusText = nullif(@stockStatusText, ''),
    stock = nullif(@stock, ''),
    externalStock = nullif(@externalStock, ''),
    incomingStock = nullif(@incomingStock, ''),
    stockAvailabilityDate = if(@stockAvailabilityDate = '',null,STR_TO_DATE(@stockAvailabilityDate, '%d.%m.%Y %H:%i')),
    lastStockUpdate = if(@lastStockUpdate = '',null,STR_TO_DATE(@lastStockUpdate, '%d.%m.%Y %H:%i')),
    priceBillingPeriod = nullif(@priceBillingPeriod, ''),
    priceBillingPeriodUnit = nullif(@priceBillingPeriodUnit, ''),
    priceSubscriptionPeriod = nullif(@priceSubscriptionPeriod, ''),
    priceSubscriptionPeriodUnit = nullif(@priceSubscriptionPeriodUnit, ''),
    priceCalcNet = nullif(@priceCalcNet, '');

LOAD DATA INFILE 'C:/temp/standardupdate_csv_21/project.csv'
  INTO TABLE ITscope_Project
  CHARACTER SET 'utf8'
  FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
  IGNORE 1 LINES
  (@projectSupplierItemId, @supplierProjectId, @manufacturerProjectId, @price, @remainingQuantity, @projectLastUpdate,@projectBundleId,@projectPosition)
  SET
    projectSupplierItemId = nullif(@projectSupplierItemId, ''),
    supplierProjectId = nullif(@supplierProjectId, ''),
    manufacturerProjectId = nullif(@manufacturerProjectId, ''),
    price = nullif(@price, ''),
    remainingQuantity = nullif(@remainingQuantity, ''),
    projectLastUpdate = if(@projectLastUpdate = '',null,STR_TO_DATE(@projectLastUpdate, '%d.%m.%Y %H:%i')),
  projectBundleId = nullif(@projectBundleId, ''),
  projectPosition = nullif(@projectPosition, '');	
  
LOAD DATA INFILE 'C:/temp/standardupdate_csv_21/supplierPackagingInfo.csv'
  INTO TABLE ITscope_SupplierPackagingInfo
  CHARACTER SET 'utf8'
  FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
  IGNORE 1 LINES
  (@supplierItemRefId, @contentUnit, @intervalQuantity, @minQuantity, @numberContentUnitPerOrderUnit, @orderUnit, @priceQuantity, @supplierPackingQuantity)
  SET
    supplierItemRefId = nullif(@supplierItemRefId, ''),
    contentUnit = nullif(@contentUnit, ''),
    intervalQuantity = nullif(@intervalQuantity, ''),
    minQuantity = nullif(@minQuantity, ''),
    numberContentUnitPerOrderUnit = nullif(@numberContentUnitPerOrderUnit, ''),
    orderUnit = nullif(@orderUnit, ''),
    priceQuantity = nullif(@priceQuantity, ''),
    supplierPackingQuantity = nullif(@supplierPackingQuantity, '');	  
  
LOAD DATA INFILE 'C:/temp/standard_csv_21/scaledPriceInfo.csv'
  INTO TABLE ITscope_ScaledPriceInfo
  CHARACTER SET 'utf8'
  FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
  IGNORE 1 LINES
  (@supplierItemRefId,@scale, @price)
  SET
	supplierItemRefId = nullif(@supplierItemRefId, ''),
    scale = nullif(@scale, ''),
    price = nullif(@price, '');  