USE developerupdate_csv_21;

SET FOREIGN_KEY_CHECKS = 0;
TRUNCATE ITscope_ProductPriceInfo;
TRUNCATE ITscope_ProductStockInfo;
TRUNCATE ITscope_Supplier;
TRUNCATE ITscope_SupplierItem;
TRUNCATE ITscope_SupplierPriceInfo;
TRUNCATE ITscope_SupplierStockInfo;
TRUNCATE ITscope_Project;
TRUNCATE ITscope_SupplierPackagingInfo;
TRUNCATE ITscope_ScaledPriceInfo;
SET FOREIGN_KEY_CHECKS = 1;

LOAD DATA INFILE 'C:/temp/developerupdate_csv_21/supplier.csv'
  INTO TABLE ITscope_Supplier
  CHARACTER SET 'utf8'
  FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
  IGNORE 1 LINES
  (@id, @name, @deeplink, @customerAccountNumber,@weeeRegNo)
  SET
    id = nullif(@id, ''),
    `name` = nullif(@name, ''),
    deeplink = nullif(@deeplink, ''),
    customerAccountNumber = nullif(@customerAccountNumber, ''),
    weeeRegNo = nullif(@weeeRegNo, '');
	

LOAD DATA INFILE 'C:/temp/developerupdate_csv_21/supplierItem.csv'
INTO TABLE ITscope_SupplierItem
CHARACTER SET 'utf8'
FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
IGNORE 1 LINES
(@id, @productId, @supplierSKU, @supplierId)
SET
  id          = nullif(@id, ''),
  productId   = nullif(@productId, ''),
  supplierSKU = nullif(@supplierSKU, ''),
  supplierId  = nullif(@supplierId, '');


LOAD DATA INFILE 'C:/temp/developerupdate_csv_21/productPriceInfo.csv'
INTO TABLE ITscope_ProductPriceInfo
CHARACTER SET 'utf8'
FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
IGNORE 1 LINES
(@productId, @price, @priceCalc, @currencyCode, @priceCalcVat, @priceLastUpdate, @minScale, @priceSourceId, @priceSourceName, @priceStatus, @priceSupplierId, @priceSupplierName, @priceSupplierItemId, @priceSupplierSKU,@priceBillingPeriod,@priceBillingPeriodUnit,@priceSubscriptionPeriod,@priceSubscriptionPeriodUnit,@priceCalcNet)
SET
  productId           = nullif(@productId, ''),
  price               = nullif(@price, ''),
  priceCalc           = nullif(@priceCalc, ''),
  currencyCode        = nullif(@currencyCode, ''),
  priceCalcVat        = nullif(@priceCalcVat, ''),
  priceLastUpdate = if(@priceLastUpdate = '',null,STR_TO_DATE(@priceLastUpdate, '%d.%m.%Y %H:%i')),
  minScale            = nullif(@minScale, ''),
  priceSourceId       = nullif(@priceSourceId, ''),
  priceSourceName     = nullif(@priceSourceName, ''),
  priceStatus         = nullif(@priceStatus, ''),
  priceSupplierId     = nullif(@priceSupplierId, ''),
  priceSupplierName   = nullif(@priceSupplierName, ''),
  priceSupplierItemId = nullif(@priceSupplierItemId, ''),
  priceSupplierSKU    = nullif(@priceSupplierSKU, ''),
  priceBillingPeriod = nullif(@priceBillingPeriod, ''),
  priceBillingPeriodUnit = nullif(@priceBillingPeriodUnit, ''),
  priceSubscriptionPeriod = nullif(@priceSubscriptionPeriod, ''),
  priceSubscriptionPeriodUnit = nullif(@priceSubscriptionPeriodUnit, ''),
  priceCalcNet           = nullif(@priceCalcNet, '');

LOAD DATA INFILE 'C:/temp/developerupdate_csv_21/productStockInfo.csv'
INTO TABLE ITscope_ProductStockInfo
CHARACTER SET 'utf8'
FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
IGNORE 1 LINES
(@productId, @stockSupplierText, @stockStatus, @stockStatusText, @stock, @externalStock, @incomingStock, @stockAvailabilityDate, @stockLastUpdate, @stockSourceId, @stockSourceName, @stockUnlimited)
SET
  productId             = nullif(@productId, ''),
  stockSupplierText     = nullif(@stockSupplierText, ''),
  stockStatus           = nullif(@stockStatus, ''),
  stockStatusText       = nullif(@stockStatusText, ''),
  stock                 = nullif(@stock, ''),
  externalStock         = nullif(@externalStock, ''),
  incomingStock         = nullif(@incomingStock, ''),
  stockAvailabilityDate = if(@stockAvailabilityDate = '',null,STR_TO_DATE(@stockAvailabilityDate, '%d.%m.%Y %H:%i')),
  stockLastUpdate = if(@stockLastUpdate = '',null,STR_TO_DATE(@stockLastUpdate, '%d.%m.%Y %H:%i')),
  stockSourceId         = nullif(@stockSourceId, ''),
  stockSourceName       = nullif(@stockSourceName, ''),
  stockUnlimited        = nullif(@stockUnlimited, '');


LOAD DATA INFILE 'C:/temp/developerupdate_csv_21/supplierPriceInfo.csv'
INTO TABLE ITscope_SupplierPriceInfo
CHARACTER SET 'utf8'
FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
IGNORE 1 LINES
(@priceSupplierItemId, @price, @priceCalc, @currencyCode, @priceCalcVat, @priceLastUpdate, @minScale, @priceSourceId, @priceSourceName, @priceStatus,@priceBillingPeriod,@priceBillingPeriodUnit,@priceSubscriptionPeriod,@priceSubscriptionPeriodUnit,@priceCalcNet)
SET
  priceSupplierItemId = nullif(@priceSupplierItemId, ''),
  price               = nullif(@price, ''),
  priceCalc           = nullif(@priceCalc, ''),
  currencyCode        = nullif(@currencyCode, ''),
  priceCalcVat        = nullif(@priceCalcVat, ''),
  priceLastUpdate = if(@priceLastUpdate = '',null,STR_TO_DATE(@priceLastUpdate, '%d.%m.%Y %H:%i')),
  minScale            = nullif(@minScale, ''),
  priceSourceId       = nullif(@priceSourceId, ''),
  priceSourceName     = nullif(@priceSourceName, ''),
  priceStatus         = nullif(@priceStatus, ''),
  priceBillingPeriod = nullif(@priceBillingPeriod, ''),
  priceBillingPeriodUnit = nullif(@priceBillingPeriodUnit, ''),
  priceSubscriptionPeriod = nullif(@priceSubscriptionPeriod, ''),
  priceSubscriptionPeriodUnit = nullif(@priceSubscriptionPeriodUnit, ''),
  priceCalcNet           = nullif(@priceCalcNet, '');

LOAD DATA INFILE 'C:/temp/developerupdate_csv_21/supplierStockInfo.csv'
INTO TABLE ITscope_SupplierStockInfo
CHARACTER SET 'utf8'
FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
IGNORE 1 LINES
(@supplierItemRefId, @supplierRefId, @stockSupplierText, @stockStatus, @stockStatusText, @stock, @externalStock, @incomingStock, @stockAvailabilityDate, @stockLastUpdate, @stockSourceId, @stockSourceName, @stockUnlimited)
SET
  supplierItemRefId     = nullif(@supplierItemRefId, ''),
  supplierRefId         = nullif(@supplierRefId, ''),
  stockSupplierText     = nullif(@stockSupplierText, ''),
  stockStatus           = nullif(@stockStatus, ''),
  stockStatusText       = nullif(@stockStatusText, ''),
  stock                 = nullif(@stock, ''),
  externalStock         = nullif(@externalStock, ''),
  incomingStock         = nullif(@incomingStock, ''),
  stockAvailabilityDate = if(@stockAvailabilityDate = '',null,STR_TO_DATE(@stockAvailabilityDate, '%d.%m.%Y %H:%i')),
  stockLastUpdate = if(@stockLastUpdate = '',null,STR_TO_DATE(@stockLastUpdate, '%d.%m.%Y %H:%i')),
  stockSourceId         = nullif(@stockSourceId, ''),
  stockSourceName       = nullif(@stockSourceName, ''),
  stockUnlimited        = nullif(@stockUnlimited, '');

LOAD DATA INFILE 'C:/temp/developerupdate_csv_21/project.csv'
INTO TABLE ITscope_Project
CHARACTER SET 'utf8'
FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
IGNORE 1 LINES
(@projectSupplierItemId, @supplierProjectId, @manufacturerProjectId, @price, @remainingQuantity, @projectLastUpdate,@projectBundleId,@projectPosition)
SET
  projectSupplierItemId     = nullif(@projectSupplierItemId, ''),
  supplierProjectId         = nullif(@supplierProjectId, ''),
  manufacturerProjectId     = nullif(@manufacturerProjectId, ''),
  price                     = nullif(@price, ''),
  remainingQuantity         = nullif(@remainingQuantity, ''),
  projectLastUpdate = if(@projectLastUpdate = '',null,STR_TO_DATE(@projectLastUpdate, '%d.%m.%Y %H:%i')),
  projectBundleId = nullif(@projectBundleId, ''),
  projectPosition = nullif(@projectPosition, '');

LOAD DATA INFILE 'C:/temp/developerupdate_csv_21/supplierPackagingInfo.csv'
  INTO TABLE ITscope_SupplierPackagingInfo
  CHARACTER SET 'utf8'
  FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
  IGNORE 1 LINES
  (@supplierItemRefId, @contentUnit, @intervalQuantity, @minQuantity, @numberContentUnitPerOrderUnit, @orderUnit, @priceQuantity, @supplierPackingQuantity)
  SET
    supplierItemRefId = nullif(@supplierItemRefId, ''),
    contentUnit = nullif(@contentUnit, ''),
    intervalQuantity = nullif(@intervalQuantity, ''),
    minQuantity = nullif(@minQuantity, ''),
    numberContentUnitPerOrderUnit = nullif(@numberContentUnitPerOrderUnit, ''),
    orderUnit = nullif(@orderUnit, ''),
    priceQuantity = nullif(@priceQuantity, ''),
    supplierPackingQuantity = nullif(@supplierPackingQuantity, '');	  

LOAD DATA INFILE 'C:/temp/developerupdate_csv_21/scaledPriceInfo.csv'
  INTO TABLE ITscope_ScaledPriceInfo
  CHARACTER SET 'utf8'
  FIELDS TERMINATED BY '\t' LINES TERMINATED BY '\r\n'
  IGNORE 1 LINES
  (@supplierItemRefId,@scale, @price)
  SET
	supplierItemRefId = nullif(@supplierItemRefId, ''),
    scale = nullif(@scale, ''),
    price = nullif(@price, '');  