CREATE TABLE `ITscope_Supplier`
(
  `id`                    BIGINT(20)    NOT NULL,
  `name`                  VARCHAR(255)  NOT NULL,
  `deeplink`              VARCHAR(2048) NOT NULL,
  `customerAccountNumber` VARCHAR(255) DEFAULT NULL,
  `weeeRegNo`             VARCHAR(12) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = latin1;

CREATE TABLE `ITscope_ProductPriceInfo`
(
  `productId`           BIGINT(20)   NOT NULL,
  `price`               DOUBLE       NOT NULL,
  `priceCalc`           DOUBLE       NOT NULL,
  `currencyCode`        VARCHAR(3)   NOT NULL,
  `priceCalcVat`        DOUBLE       NOT NULL,
  `priceLastUpdate`     DATETIME     NOT NULL,
  `minScale`            INT(11)      NOT NULL,
  `priceSourceId`       INT(11)      NOT NULL,
  `priceSourceName`     VARCHAR(255) NOT NULL,
  `priceStatus`         VARCHAR(255) NOT NULL,
  `priceSupplierId`     BIGINT(20)   NOT NULL,
  `priceSupplierName`   VARCHAR(255) NOT NULL,
  `priceSupplierItemId` BIGINT(20)   NOT NULL,
  `priceSupplierSKU`    VARCHAR(150) NOT NULL,
  `priceBillingPeriod`        INT(11)       DEFAULT NULL,
  `priceBillingPeriodUnit`    VARCHAR(40)   DEFAULT NULL,
  `priceSubscriptionPeriod`   INT(11)       DEFAULT NULL,
  `priceSubscriptionPeriodUnit` VARCHAR(40) DEFAULT NULL,
  `priceCalcNet`           DOUBLE       NOT NULL,
  PRIMARY KEY (`productId`)
) ENGINE = InnoDB
  DEFAULT CHARSET = latin1;

CREATE TABLE `ITscope_ProductStockInfo`
(
  `productId`             BIGINT(20)   NOT NULL,
  `stockSupplierText`     VARCHAR(40) DEFAULT NULL,
  `stockStatus`           INT(11)      NOT NULL,
  `stockStatusText`       VARCHAR(255) NOT NULL,
  `stock`                 INT(11)      NOT NULL,
  `externalStock`         INT(11)     DEFAULT NULL,
  `incomingStock`         INT(11)     DEFAULT NULL,
  `stockAvailabilityDate` DATETIME    DEFAULT NULL,
  `stockLastUpdate`       DATETIME     NOT NULL,
  `stockSourceId`         INT(11)      NOT NULL,
  `stockSourceName`       VARCHAR(255) NOT NULL,
  `stockUnlimited`        VARCHAR(5)   NOT NULL,
  PRIMARY KEY (`productId`)
)
  ENGINE = InnoDB
  DEFAULT CHARSET = latin1;


CREATE TABLE `ITscope_SupplierItem`
(
  `id`          BIGINT(20) NOT NULL,
  `productId`   BIGINT(20) NOT NULL,
  `supplierSKU` VARCHAR(150) DEFAULT NULL,
  `supplierId`  BIGINT(20) NOT NULL,
  PRIMARY KEY (`productId`, `id`),
  KEY `si_supplier` (`supplierId`),
  KEY `si_product` (`productId`),
  CONSTRAINT `si_product` FOREIGN KEY (`productId`) REFERENCES `ITscope_Product` (`puid`),
  CONSTRAINT `si_supplier` FOREIGN KEY (`supplierId`) REFERENCES `ITscope_Supplier` (`id`)
)
  ENGINE = InnoDB
  DEFAULT CHARSET = latin1;
ALTER TABLE ITscope_SupplierItem
  ADD INDEX (id);

CREATE TABLE `ITscope_SupplierPriceInfo`
(
  `priceSupplierItemId` BIGINT(20)   NOT NULL,
  `price`               DOUBLE       NOT NULL,
  `priceCalc`           DOUBLE       NOT NULL,
  `currencyCode`        VARCHAR(3)   NOT NULL,
  `priceCalcVat`        DOUBLE       NOT NULL,
  `priceLastUpdate`     DATETIME     NOT NULL,
  `minScale`            INT(11)      NOT NULL,
  `priceSourceId`       INT(11)      NOT NULL,
  `priceSourceName`     VARCHAR(255) NOT NULL,
  `priceStatus`         VARCHAR(255) NOT NULL,
  `priceBillingPeriod`        INT(11)       DEFAULT NULL,
  `priceBillingPeriodUnit`    VARCHAR(40)   DEFAULT NULL,
  `priceSubscriptionPeriod`   INT(11)       DEFAULT NULL,
  `priceSubscriptionPeriodUnit` VARCHAR(40) DEFAULT NULL,
  `priceCalcNet`        DOUBLE       NOT NULL,
  PRIMARY KEY (`priceSupplierItemId`, `minScale`, `priceSourceId`)
)
  ENGINE = InnoDB
  DEFAULT CHARSET = latin1;

CREATE TABLE `ITscope_SupplierStockInfo`
(
  `supplierItemRefId`     BIGINT(20)   NOT NULL,
  `supplierRefId`         BIGINT(20)   NOT NULL,
  `stockSupplierText`     VARCHAR(40) DEFAULT NULL,
  `stockStatus`           INT(11)      NOT NULL,
  `stockStatusText`       VARCHAR(255) NOT NULL,
  `stock`                 INT(11)      NOT NULL,
  `externalStock`         INT(11)     DEFAULT NULL,
  `incomingStock`         INT(11)     DEFAULT NULL,
  `stockAvailabilityDate` DATETIME    DEFAULT NULL,
  `stockLastUpdate`       DATETIME     NOT NULL,
  `stockSourceId`         INT(11)      NOT NULL,
  `stockSourceName`       VARCHAR(255) NOT NULL,
  `stockUnlimited`        VARCHAR(5)   NOT NULL,
  PRIMARY KEY (`supplierItemRefId`, `stockSourceId`)
) ENGINE = InnoDB
  DEFAULT CHARSET = latin1;

CREATE TABLE `ITscope_Project`
(
  `projectSupplierItemId` BIGINT(20)  NOT NULL,
  `supplierProjectId`     VARCHAR(40) NOT NULL,
  `manufacturerProjectId` VARCHAR(40) NOT NULL,
  `price`                 DOUBLE      NOT NULL,
  `remainingQuantity`     INT(8)   DEFAULT NULL,
  `projectLastUpdate`     DATETIME DEFAULT NULL,
  `projectBundleId`       VARCHAR(50)    DEFAULT NULL,
  `projectPosition`       INT(8)      DEFAULT NULL,
  PRIMARY KEY (`projectSupplierItemId`, `manufacturerProjectId`, `projectBundleId`, `projectPosition`),
  KEY `pr_supplItem` (`projectSupplierItemId`),
  CONSTRAINT `pr_supplItem` FOREIGN KEY (`projectSupplierItemId`) REFERENCES `ITscope_SupplierItem` (`id`)
)
  ENGINE = InnoDB
  DEFAULT CHARSET = latin1;

CREATE TABLE `ITscope_SupplierPackagingInfo`
(
    `supplierItemRefId`              BIGINT(20)  NOT NULL,
    `contentUnit`                    VARCHAR(50) DEFAULT NULL,
    `intervalQuantity`               INT(8)       DEFAULT NULL,
    `minQuantity`                    INT(8)       DEFAULT NULL,
    `numberContentUnitPerOrderUnit`  INT(8)       DEFAULT NULL,
    `orderUnit`                      VARCHAR(50) NOT NULL,
    `priceQuantity`                  INT(8)       DEFAULT NULL,
    `supplierPackingQuantity`        INT(8)       DEFAULT NULL,

    PRIMARY KEY (`supplierItemRefId`),
    KEY `pi_supplItem` (`supplierItemRefId`),
    CONSTRAINT `pi_supplItem` FOREIGN KEY (`supplierItemRefId`) REFERENCES `ITscope_SupplierItem` (`id`)
)
    ENGINE = InnoDB
    DEFAULT CHARSET = latin1;

CREATE TABLE `ITscope_ScaledPriceInfo`
(
    `supplierItemRefId`              BIGINT(20)  NOT NULL,
    `scale`                          INT(8) NOT NULL,
    `price`                          DOUBLE  NOT NULL,

    PRIMARY KEY (`supplierItemRefId`,`scale`),
    KEY `spi_supplItem` (`supplierItemRefId`),
    CONSTRAINT `spi_supplItem` FOREIGN KEY (`supplierItemRefId`) REFERENCES `ITscope_SupplierItem` (`id`)
)
    ENGINE = InnoDB
    DEFAULT CHARSET = latin1;		


SET FOREIGN_KEY_CHECKS = 0;
TRUNCATE ITscope_ProductPriceInfo;
TRUNCATE ITscope_ProductStockInfo;
TRUNCATE ITscope_Supplier;
TRUNCATE ITscope_SupplierItem;
TRUNCATE ITscope_SupplierPriceInfo;
TRUNCATE ITscope_SupplierStockInfo;
TRUNCATE ITscope_Project;
TRUNCATE ITscope_SupplierPackagingInfo;
TRUNCATE ITscope_ScaledPriceInfo;
SET FOREIGN_KEY_CHECKS = 1;